// Arduino RCS Library v1.0.0

#ifndef RCS_H
#define RCS_H

#include "Arduino.h"


/* RCS_Timer and RCS_Button classes
 * based on RBD Timer and RBD Button
 * Thanks to Alex Taujenis
 * https://github.com/alextaujenis/RBD_Timer
 * Copyright 2016 Alex Taujenis
 * MIT License
 */






namespace RCS {
  class Timer {
    public:
      Timer();                              // constructor with zero timeout, starts in "expired" state by default
      Timer(unsigned long value);           // overloaded constructor: provide a setTimeout in milliseconds, starts in "expired" state by default
    
    unsigned long getValue();               // how long since timer restart/reset

      unsigned long getTimeout();
      void setTimeout(unsigned long value); // set/change how long the timer will run until it expires in milliseconds

      void restart();                       // reset and start the timer
      void stop();                          // stop the timer
      bool isActive();                      // check if time is left
      bool isExpired();                     // returns true if time has run out
      bool isStopped();                     // returns true if the timer is stopped
      bool onRestart();                     // returns true if the timer is expired and restarts the timer automatically
      bool onActive();                      // returns true once the timer is active, then waits for it to expire and go active again
      bool onExpired();                     // returns true once the timer is expired, then waits for it to go active and expire again
    private:
      unsigned long _timeout  = 0;          // how long this timer should run for
      unsigned long _waypoint = 0;          // the point in time the timer was started or reset
      bool _has_been_active   = false;      // helps fire the onActive event only once
      bool _has_been_expired  = false;      // helps fire the onExpired event only once
      void _updateState();                  // maintains timer current state, helps eliminate rollover issues
      enum {ACTIVE, EXPIRED, STOPPED} _state = EXPIRED;  // timer internal states, constructed in "expired" state by default
  };
  
  class Button {
  public:
    Button(int pin);                    // constructor: input pullup enabled by default
    Button(int pin, bool input_pullup); // overloaded constructor: flag available to disable input pullup
    void setDebounceTimeout(unsigned long value);
    bool isPressed();
    bool isReleased();
    bool onPressed();
    bool onReleased();
    void invertReading();
  private:
    int _pin;
    unsigned long _debounce_timeout = 10; // ms
    bool _has_been_pressed  = false;
    bool _has_been_released = false;
    bool _invert = true;
    bool _temp_reading;
    void _inputPullup();
    void _disableInputPullup();
    Timer _pressed_debounce;
    Timer _released_debounce;
  };
  
}
#endif
