
/***** HORN METHODS *****/
long int hornOnMillis; // just for debugging

void hornON()  
{ 
    relayON(hornRelayPin);
  if (debug) { 
    hornOnMillis = millis(); 
    Serial.print(F("Horn ON @ "));Serial.println(float(millis()/1000.0),2); }
}

void hornOFF() {
 long int hornOnTime;
 relayOFF(hornRelayPin);
  if (debug) { hornOnTime = millis() - hornOnMillis;
    Serial.print(F("Horn OFF after "));Serial.print(float(hornOnTime*speedUp/1000.0),1); Serial.println(F(" secs"));}
}

bool hornIsON()
{
  return (digitalRead(hornRelayPin) == relayActiveState);
}

bool hornIsOFF() {
  return (digitalRead(hornRelayPin) == !relayActiveState);
}

/* hornTimedON(s)
 *  s = time in 1/10ths seconds
 */
void hornTimedON(byte s) {
  hornON();
  hornTimer.setTimeout(s*98/speedUp);  // * 100 -> msecs (allow 2msec for code execution, as only check every 1/10th sec)
  hornTimer.restart(); // start now
}

/* hornTimedOFF(s)
 *  s = time in 1/10ths seconds
 */
void hornTimedOFF(byte s) {
  hornOFF();
  hornTimer.setTimeout(s*98/speedUp); // * 100 -> msecs (allow 2msec for code execution, as only check every 1/10th sec)
  hornTimer.restart(); // start now
}

/*
 * Do a HORN SOUND Sequence
 * uses globals: 
 *   arrays aStartTimes[], aSoundDefs[][3] and aSounds[], aTeamStartTimes[], aTeamSounds[]
 *   e.g. 
 *   int aStartTimes[] = { -300, -180, -120, -60, 0, NOTUSED,60,120,180 }
 *   the values may NOT always match the values for lights (e.g. ...0,15,60... but 15 has no sound)
 *   byte aSoundDefs[][3] = { {0,0,0}, {5,5,5},{1,15,0},{1,25,0},{2,25,0}, {3,25,0} };
 *   for { No sound, Race Warning, HOOT, LONG HOOT (1 min), 2 long Postpone, 3 Long Abandon }
 *   aSounds[] is the sequence to match the start lights
 *   aSounds[9] = {1, 2, 2, 3, 2, 0, 2, 3, 2}
 *   
 *   bool hornIsRunning
 *   
 * array structure is { {num_Sounds,sound_length,pause_length} [, {....}] };
 * (see rbd_testing for simple tests of this structure)
 * 
 */

void doHorn() {
  int i;
  if ( hornIsRunning )
    soundTheHorn(-1); // already running, continue sounds until done  
  else
  {    
    i = getStartTimesMatch(teamRace); // check both main AND teamRace times

   // if ( debug ) { Serial.print(F(" DoHorn indix i="));Serial.println(i); }    
    
    if ( i % NOTUSED != 0 )
      soundTheHorn(i); // start a horn sound (sequence)
  }
}  



void soundTheHorn(int soundIndex) {
  static byte _hornRepeatNum = 0;
  static byte _hornRepeats = 0;
  static byte _hornGap = 0;
  static byte _hornLength = 0;

  if ( !hornIsRunning && soundIndex >=0 ) // time to start the sound(s) defined by SoundIndex
  { 
 
    _hornRepeats = aSoundDefs[soundIndex][0];  // 1st entry is # of sounds in 1/10ths sec
    _hornLength  = aSoundDefs[soundIndex][1];  // 2nd entry is length in 1/10ths sec
    _hornGap     = aSoundDefs[soundIndex][2];  // 3rd is pause (if > 1 sound) in 1/10ths sec
    _hornRepeatNum = 1;
    // set the requested time = timeout(msecs) for 1st horn sound, and turn on
    hornTimedON(_hornLength); // 1/10ths of seconds
    hornIsRunning = true; // set our GLOBAL flag
    if ( debug ) { Serial.print(F("Horn Repeat "));Serial.println(_hornRepeatNum); }
  }
  else
  {
    if ( hornTimer.onExpired() ) // only fires ONCE when we reach the timeout
    {      
      if ( _hornRepeatNum < _hornRepeats )
      {
        if ( hornIsOFF() ) // turn it on
        {
          _hornRepeatNum++; // set the timeout for ON
          hornTimedON(_hornLength);
          if ( debug ) { Serial.print(F("Repeat  "));Serial.println(_hornRepeatNum); }
                
        }else // horn is on, turn it off!
        {                
          hornTimedOFF(_hornGap); // hornOFF() for silent pauses,           
          if ( debug ) 
          { 
            Serial.print(F("Pause  ")); Serial.println(_hornRepeatNum);
            //Serial.print(F(" @ "));Serial.println(float(millis()/1000.0),2); 
          }
        } // else hornRepeatNum
           
      }else // no repeats or all done
      {
        hornOFF();
        hornIsRunning = false; // flag to main loop() that we are done
        _hornRepeatNum = 0; // reset it for next time (just safety)
    
        if ( debug ) { 
          // Serial.print(F("  hornIsOFF() @ ")); Serial.println(float(millis()/1000.0),2);
          Serial.println(F("Horn ALL DONE!"));
        }
      }
    }  // onExpired()   
  } // else
}

