

/**** BUTTONS **** 
 *  use library RCS (based on RBD_Button) methods: 
 * .onPressed()Event
 * .onReleased()Event
 * .setDebounceTimeout(value)
 * .isPressed()
 * .isReleased()
 */
/*
 * checkHornbutton()
 * fires the Horn relay while pressed
 * called this every 1/10th second
 */
bool checkHornButton() {
  static bool hornLogging = false;
 
  if (hornBtn.onPressed())  
    relayON(hornRelayPin); // horn relay ON

  if (hornBtn.onReleased())
    relayOFF(hornRelayPin);
}

/* checkHornAndRecallButtons()
 *  loop() calls this every 1/10th second
 *  if sounding an automatic signal, check if time to turn off,
 *  else test for manual horn and recall button presses
 */
void checkHornAndRecallButtons() {
  if (hornIsRunning) 
  { // automatic horn sequence is in progress,   
    soundTheHorn(-1);       // check if it has finished yet
  }
  else{  
      checkHornButton();    // for manual press
      checkRecallButton();  // individual or flight recalls   
  }
}


void checkShortenCourse()
{
  static bool isShortenCourse = false;
  
  if ( isShortenCourse == true )    // > 10 minutes gone  
  {
    ShortenCourse(true); // toggle the Class & Prep lights
  }

  if (recallBtn.onPressed()) 
  {
    if ( isShortenCourse == false )
    { 
      isShortenCourse = true;
      hornOFF(); // ensure at start it is off!
      LCDdisplayTextLine(aRaceNamesx[2],0); // give Shorten Course message
      soundTheHorn(4);    // 2 hoots - see aSounds[] 
    }else{
      isShortenCourse = false; // cancel it
      ShortenCourse(false); // lights off
    }
  }
}


/*
 * ShortenCourse()
 * Triggered by Recall button if race time > x minutes
 */
void ShortenCourse(bool on)
{
  static long int secs;
  if (on) {
    if ( loopCount > secs )
    {
      if ( odd(loopCount) )
      {
        relayON(classRelayPin); 
        relayOFF(prepRelayPin);
      }else{
        relayOFF(classRelayPin); 
        relayON(prepRelayPin);
      }
      secs = loopCount;
    }
  }else{
    relayOFF(classRelayPin);
    relayOFF(prepRelayPin);
  }
}


/* haveRacedFor(int secsAfterStart) 
 *  Called by recall button to decide if enough time 
 *  has elapsed to enable as "shorten course"
 */
bool haveRacedFor(int secsAfterStart) {
  return bool(timeCount > aStartTimes[tZeroIndex] + secsAfterStart);
}

/* checkRecallBtn()
 * 
 * called every 1/10th sec from loop()
 * RETURNS raceInProgress state, as recalls affect this (see comment below) 
 * 
 * Checks are based on race TIME
 * RECALLS:
 * At each flight start the Recall button is enabled for ~15 secs
 *  One Press for Individual recall, two for Flight recall (increments numFlights and ensures raceInProgress = false)
 * CANCEL RECALL:
 *  After 15 secs (until next race signal, usully 60 secs) pressing Recall again will turn off the lights 
 * SHORTEN COURSE:
 * After haveRacedFor(x seconds) pressing the Recall button will trigger "Shorten Course". 
 *  This give 2 hoots and toggles the Class & Prep lights.
 */
bool  checkRecallButton() 
{
 static byte iRecall = 0;
 static long int secs = 0; // to allow toggle of recall lamps
 String msg1 = " Recall Button  ";
 
  if (rcstate < 5) return raceInProgress; // cannot recall until a flight has started!
  
  // time to enable button for 'Shorten Course'?
  if ( haveRacedFor(enableShortCourseAfterSecs) ) 
  {
    checkShortenCourse(); // go do it
    return true; // must be raceInProgress by now!
  }
  
  // check recalls. We know time is > GO for the flight (as state >=5)
  if (recallBtn.onPressed()) 
  {
    if ( timeCount < aStartTimes[nextValidActionNdx(tZeroIndex+1)] ) // use function to cover possibility that the index is NOTUSED
    { // it is shortly after a start - enable RECALL
      if ( iRecall == 2 )  
        return raceInProgress; // already done, so exit now with unchanged value
      else
      {
        relayON(recallRelayPin);         // race recall (Warn) light ON
        soundTheHorn(2);    // one hoot - see aSounds[]  
        iRecall++;    // to 1 = Individual Recall, 2 = Flight Recall
        if ( debug ) {  
          Serial.print(msg1);Serial.println(F("Pressed")); Serial.print(F("iRecall="));Serial.println(iRecall); 
        }
        if (iRecall == 1) LCDdisplayTextLine(aRaceNamesx[0],0);// lcd.setCursor(0,0); lcd.print(aRaceNamesx[0]);
        // check new value
        if (iRecall == 2 )  { // flight recall
          LCDdisplayTextLine(aRaceNamesx[1],0); // lcd.setCursor(0,0); lcd.print(aRaceNamesx[1]);
          numFlights++;       // this flight will restart
          raceInProgress = false; // need countdown for recalled flight
        }
      }
    }else // long enough, cancel the recall
    {
      if (iRecall > 0) {
        relayOFF(recallRelayPin);
        iRecall = 0;
        if ( debug ) Serial.println(F("Recall Cancelled"));
      }      
    } // else
  } // recall.onPressed()
  
  
  // if a recall is active, check if need to blink, or time to cancel it (if user did not!)
  if (iRecall > 0) // an indiv. or flight recall is active
    if ( timeCount < aStartTimes[nextValidActionNdx(tZeroIndex+2)] -1)
    { 
      if ( (iRecall == 2) && ( loopCount > secs ) ) // Flight recall, blink the lamp
      {   
        relayToggle(recallRelayPin); 
        secs = loopCount;
        if ( debug ) Serial.println(F("Toggle recall"));
      }
    }else{ // later, if not already cancelled by user (see above), cancel now
      if ( iRecall > 0) {
        relayOFF(recallRelayPin);
        iRecall = 0;
        if ( debug ) Serial.println(F("Recall off"));
      }
    }
  return raceInProgress; // if we recalled a flight, this is now false!
}

